/* SigmaStar trade secret */
/* Copyright (c) [2019~2020] SigmaStar Technology.
All rights reserved.

Unless otherwise stipulated in writing, any and all information contained
herein regardless in any format shall remain the sole proprietary of
SigmaStar and be kept in strict confidence
(SigmaStar Confidential Information) by the recipient.
Any unauthorized act including without limitation unauthorized disclosure,
copying, use, reproduction, sale, distribution, modification, disassembling,
reverse engineering and compiling of the contents of SigmaStar Confidential
Information is unlawful and strictly prohibited. SigmaStar hereby reserves the
rights to any and all damages, losses, costs and expenses resulting therefrom.
*/


#if defined(__KERNEL__)
#define CAM_OS_LINUX_KERNEL
#endif

#ifdef CAM_OS_RTK
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#elif defined (CAM_OS_LINUX_KERNEL)
//#include <fs/proc/internal.h>
#include <linux/uaccess.h>
#include <linux/proc_fs.h>
#endif

#include "cam_os_wrapper.h"
#include "cam_proc_common.h"
#include "cam_proc_wrapper.h"

struct CamOsListHead_t _proc_root_list = {&_proc_root_list,&_proc_root_list};
CamOsMutex_t gProcMutex;
u8 gbIsProcInit;

static CamProcEntry_t * _CamProcFindEntry(struct CamOsListHead_t * pSrcList , CamProcEntry_t * pDstEntry)
{
    CamProcEntry_t *pSubEntry = NULL;
    struct CamOsListHead_t *l;
    CamProcEntry_t *pTmpListEntry;

    CAM_OS_LIST_FOR_EACH( l, pSrcList ) {
        pTmpListEntry = CAM_OS_LIST_ENTRY( l, CamProcEntry_t, link );
        if(pTmpListEntry == pDstEntry) {
            return pTmpListEntry;
        }
        else {
            pSubEntry = _CamProcFindEntry(&pTmpListEntry->sSubNodeList, pDstEntry);
            if(pSubEntry)
                return pSubEntry;
        }
    }

    return NULL;
}

static CamProcEntry_t * _CamProcFindEntryByNameEx(struct CamOsListHead_t * pSrcList , const char *name)
{
    CamProcEntry_t *pFoundSubEntry = NULL;
    struct CamOsListHead_t *l;
    CamProcEntry_t * pTmpListEntry;

    CAM_OS_LIST_FOR_EACH( l, pSrcList ) {
        pTmpListEntry = CAM_OS_LIST_ENTRY( l, CamProcEntry_t, link );

        if(strcmp(pTmpListEntry->aEntryName,name) == 0) {
            return pTmpListEntry;
        }
        else {
            pFoundSubEntry = _CamProcFindEntryByNameEx(&pTmpListEntry->sSubNodeList, name);
            if(pFoundSubEntry)
                return pFoundSubEntry;
        }
    }
    return NULL;
}

#ifdef CAM_OS_RTK

#elif defined (CAM_OS_LINUX_KERNEL)
static int _CamProcShowLinux(struct seq_file *m, void *v)
{
    CamProcNodeOp_t *op = m->private;

    if (op->cat)
        op->cat((CamProcSeqBuf_t*)m, m->count);

    return 0;
}

static int _CamProcOpenLinux(struct inode *inode, struct file *file)
{
    return single_open(file, _CamProcShowLinux, PDE_DATA(inode));
}

static ssize_t _CamProcWriteLinux(struct file *file, const char __user *buf, size_t count, loff_t *ppos)
{
    CamProcNodeOp_t *op = ((struct seq_file *)file->private_data)->private;

    if (op->echo)
    {
        u32 n;
        void * tmp_buf;
        tmp_buf = CamOsMemAlloc(count);
        if(!tmp_buf) {
            printk(KERN_ERR "%s %d No available memory\n", __FUNCTION__, __LINE__);
            return count;
        }
        n = copy_from_user(tmp_buf, buf, count);
        op->echo(tmp_buf, count);
        CamOsMemRelease(tmp_buf);
    }

    return count;
}
#endif

static CamProcDirEntry_t * _CamProcCreateEntryNode(const char *name, CamProcEntry_t *pParentEntry, CamProcCatCB pCatCB, CamProcEchoCB pEchoCB)
{
#ifdef CAM_OS_RTK
#elif defined (CAM_OS_LINUX_KERNEL)
    struct proc_dir_entry *pNewPde = NULL;
    CamProcPrivate_t * pNewPrivate = NULL;
#endif
    int i;
    CamProcEntry_t *pFoundEntry = NULL;
    struct CamOsListHead_t *pRootEntryList = NULL;
    CamProcEntry_t *pNewEntry = NULL;

#ifdef CAM_OS_RTK
    //CamOsPrintf("CamProcEntry_t size = %d\n",sizeof(CamProcEntry_t));
    pNewEntry = CamOsMemAlloc(sizeof(CamProcEntry_t));

    if(!pNewEntry)
        return NULL;

    if(!gbIsProcInit) {
        gbIsProcInit = 1;
        CamOsMutexInit(&gProcMutex);
    }

    CAM_OS_INIT_LIST_HEAD(&pNewEntry->link);
    CAM_OS_INIT_LIST_HEAD(&pNewEntry->sSubNodeList);
    for(i = 0 ; i < strlen(name) && i < sizeof(pNewEntry->aEntryName) - 1; i++) {
        pNewEntry->aEntryName[i] = *(name+i);
    }
    pNewEntry->aEntryName[i] = 0;
    pNewEntry->pfCatCB = pCatCB;
    pNewEntry->pfEchoCB = pEchoCB;

    CamOsMutexLock(&gProcMutex);

    if(pParentEntry) {
        pFoundEntry = _CamProcFindEntry(&_proc_root_list, (CamProcEntry_t *)pParentEntry);
    }

    if(pFoundEntry) {
        pRootEntryList = &pFoundEntry->sSubNodeList;
    }
    else {
        pRootEntryList = &_proc_root_list;
    }

    CAM_OS_LIST_ADD_TAIL(&pNewEntry->link,pRootEntryList);

    CamOsMutexUnlock(&gProcMutex);
#elif defined (CAM_OS_LINUX_KERNEL)
    if(pCatCB) {
        pNewPrivate = CamOsMemAlloc(sizeof(CamProcPrivate_t));
        if(!pNewPrivate)
            return NULL;

        pNewPrivate->sProcOps.cat = pCatCB;
        pNewPrivate->sProcOps.echo = pEchoCB;

        memset((void*)&pNewPrivate->pFileOps, 0, sizeof(struct file_operations));
        pNewPrivate->pFileOps.owner = THIS_MODULE;
        pNewPrivate->pFileOps.open = _CamProcOpenLinux;
        pNewPrivate->pFileOps.write = _CamProcWriteLinux;
        pNewPrivate->pFileOps.read = seq_read;
        pNewPrivate->pFileOps.llseek = seq_lseek;
        pNewPrivate->pFileOps.release = single_release;

        if(pParentEntry)
            pNewPde = proc_create_data(name, S_IRUGO, pParentEntry->pde, &pNewPrivate->pFileOps, &pNewPrivate->sProcOps);
        else
            pNewPde = proc_create_data(name, S_IRUGO, NULL, &pNewPrivate->pFileOps, &pNewPrivate->sProcOps);
    }
    else {
        if(pParentEntry)
            pNewPde = proc_mkdir(name, pParentEntry->pde);
        else
            pNewPde = proc_mkdir(name, NULL);
    }

    if(!pNewPde) {
        return NULL;
    }

    pNewEntry = CamOsMemAlloc(sizeof(CamProcEntry_t));

    if(!pNewEntry)
        return NULL;

    if(!gbIsProcInit) {
        gbIsProcInit = 1;
        CamOsMutexInit(&gProcMutex);
    }

    CAM_OS_INIT_LIST_HEAD(&pNewEntry->link);
    CAM_OS_INIT_LIST_HEAD(&pNewEntry->sSubNodeList);

    for(i = 0 ; i < strlen(name) && i < sizeof(pNewEntry->aEntryName) - 1; i++) {
        pNewEntry->aEntryName[i] = *(name+i);
    }
    pNewEntry->aEntryName[i] = 0;
    pNewEntry->pde = pNewPde;
    pNewEntry->pdata = pNewPrivate;

    CamOsMutexLock(&gProcMutex);

    if(pParentEntry) {
        pFoundEntry = _CamProcFindEntry(&_proc_root_list, (CamProcEntry_t *)pParentEntry);
    }

    if(pFoundEntry) {
        pRootEntryList = &pFoundEntry->sSubNodeList;
    }
    else {
        pRootEntryList = &_proc_root_list;
    }

    CAM_OS_LIST_ADD_TAIL(&pNewEntry->link,pRootEntryList);

    CamOsMutexUnlock(&gProcMutex);
#endif
    return (void *)pNewEntry;
}

static void _CamProcRemoveAllSubNode(CamProcEntry_t *pParentEntry,CamProcEntry_t *pCurrentEntry)
{
    struct CamOsListHead_t *l;
    CamProcEntry_t *pSubNodeEntry;

    //CAM_OS_LIST_FOR_EACH(pos, head) : for (pos = (head)->pNext; pos != (head); pos = pos->pNext)
    CAM_OS_LIST_FOR_EACH( l, &pCurrentEntry->sSubNodeList ) {
        pSubNodeEntry = CAM_OS_LIST_ENTRY( l, CamProcEntry_t, link );
        _CamProcRemoveAllSubNode(pCurrentEntry,pSubNodeEntry);
        l = &pCurrentEntry->sSubNodeList;
    }

#ifdef CAM_OS_RTK
#elif defined (CAM_OS_LINUX_KERNEL)
    if(pParentEntry == pCurrentEntry || pParentEntry == NULL)
        remove_proc_entry(pCurrentEntry->aEntryName, NULL);
    else
        remove_proc_entry(pCurrentEntry->aEntryName, pParentEntry->pde);
    if(pCurrentEntry->pdata)
        CamOsMemRelease((void *)pCurrentEntry->pdata);
#endif

    CAM_OS_LIST_DEL(&pCurrentEntry->link);
    CamOsMemRelease((void *)pCurrentEntry);
}

static void _CamProcRemoveEntryNode(const char *name, CamProcEntry_t *pParentEntry)
{
    CamProcEntry_t *pFoundEntry = NULL;
    struct CamOsListHead_t *pRootEntryList = NULL;
    CamProcEntry_t *pRmEntry = NULL;

    if(!gbIsProcInit) {
        gbIsProcInit = 1;
        CamOsMutexInit(&gProcMutex);
    }

    CamOsMutexLock(&gProcMutex);

    if(pParentEntry) {
        pFoundEntry = _CamProcFindEntry(&_proc_root_list, (CamProcEntry_t *)pParentEntry);
    }

    if(pFoundEntry) {
        pRootEntryList = &pFoundEntry->sSubNodeList;
    }
    else {
        pRootEntryList = &_proc_root_list;
    }

    pRmEntry = _CamProcFindEntryByNameEx(pRootEntryList, name);

    if(pRmEntry) {
        _CamProcRemoveAllSubNode(pParentEntry,pRmEntry);
    }

    CamOsMutexUnlock(&gProcMutex);
}

CamProcDirEntry_t* CamProcMkdir(const char *name, CamProcDirEntry_t *pParentEntry)
{
    return _CamProcCreateEntryNode(name, (CamProcEntry_t *)pParentEntry, NULL, NULL);
}

CamProcDirEntry_t* CamProcCreate(const char *name, u16 umode, CamProcDirEntry_t * pParentEntry, CamProcCatCB pCatCB, CamProcEchoCB pEchoCB)
{
    return _CamProcCreateEntryNode(name, (CamProcEntry_t *)pParentEntry, pCatCB, pEchoCB);
}

void CamProcRemoveEntry(const char *name, CamProcDirEntry_t * pParentEntry)
{
    _CamProcRemoveEntryNode(name, pParentEntry);
}



